package game;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;


public class RainSprite {
	
	private Color rainColor;
	private ArrayList<RainDrop> drops;
	private boolean shouldRain;
	
	public static final int DROP_HEIGHT = 20;
	public static final int MAX_DROPS = 500;
	public static final int MAX_DROP_SPAWNS_PER_TICK = 30;
	public static final int MIN_DROP_SPAWNS_PER_TICK = 10;
	public static final int MIN_DELTA_X = -10;
	public static final int MAX_DELTA_X = 10;
	public static final int MIN_DELTA_Y = 25;
	public static final int MAX_DELTA_Y = 50;
	public static final int MIN_START_Y = -30;
	public static final int MAX_START_Y = -5;

	public static final int ADDITIONAL_LEFT_OFFSET = Math.max(PonyPanel.PANEL_HEIGHT * MAX_DELTA_X / MIN_DELTA_Y, 0);
	public static final int ADDITIONAL_RIGHT_OFFSET = Math.max(PonyPanel.PANEL_HEIGHT * -MIN_DELTA_X / MIN_DELTA_Y, 0);
	
	
	
	public class RainDrop {
		private Point lowPoint;
		private Point highPoint;
		private int deltaX;
		private int deltaY;
		
		public RainDrop(int x, int y, int xSpeed, int ySpeed) {
			lowPoint = new Point(x, y);
			highPoint = new Point(x - DROP_HEIGHT * xSpeed / ySpeed, y - DROP_HEIGHT); 
			deltaX = xSpeed;
			deltaY = ySpeed;
		}
		
		public boolean updateReturnCanDespawn(int maxX, int maxY) {
			lowPoint.y += deltaY;
			lowPoint.x += deltaX;
			highPoint.y += deltaY;
			highPoint.x += deltaX;
			
			if(highPoint.y > maxY || highPoint.x < 0 - ADDITIONAL_LEFT_OFFSET || highPoint.x > maxX + ADDITIONAL_RIGHT_OFFSET)
				return true;
			else
				return false;
		}
		
		public void draw(Graphics g) {
			g.drawLine(lowPoint.x, lowPoint.y, highPoint.x, highPoint.y);
		}
	}
	
	
	public RainSprite(Color col) {
		
		rainColor = col;
		
		drops = new ArrayList<RainSprite.RainDrop>();
		
		shouldRain = true;
		
	}
	
	public void update() {
		
		if(shouldRain) {
			
			int randomNumDropsToSpawn = (int) (Math.random() * (MAX_DROP_SPAWNS_PER_TICK - MIN_DROP_SPAWNS_PER_TICK)) + MIN_DROP_SPAWNS_PER_TICK;
			int maxDropsToSpawn = MAX_DROPS - drops.size();
			
			int dropsToSpawn = Math.min(maxDropsToSpawn, randomNumDropsToSpawn);
			
			int dropX, dropY, deltaX, deltaY;
			
			for(int i = 0; i < dropsToSpawn; i++) {
				
				dropX = (int) (Math.random() * (PonyPanel.PLAY_AREA_WIDTH + ADDITIONAL_LEFT_OFFSET + ADDITIONAL_RIGHT_OFFSET)) - ADDITIONAL_LEFT_OFFSET;
				deltaX = (int) (Math.random() * (MAX_DELTA_X - MIN_DELTA_X)) + MIN_DELTA_X;
				deltaY = (int) (Math.random() * (MAX_DELTA_Y - MIN_DELTA_Y)) + MIN_DELTA_Y;
				dropY = (int) (Math.random() * (MAX_START_Y - MIN_START_Y)) + MIN_START_Y;
				drops.add(new RainDrop(dropX, dropY, deltaX, deltaY));
			}
			
		}
		
		for(int i = 0; i < drops.size(); i++) {
			if(drops.get(i).updateReturnCanDespawn(PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT)) {
				drops.remove(i);
				i--;
			}
		}
		
	}
	
	public void draw(Graphics g) {
		
		Color origCol = g.getColor();
		
		g.setColor(rainColor);
		
		for(int i = 0; i < drops.size(); i++) {
			drops.get(i).draw(g);
		}
		
		
		g.setColor(origCol);
		
	}
	
	public boolean isDoneRaining() {
		return drops.isEmpty();
	}
	
	
	public boolean shouldRain() {
		return shouldRain;
	}
	
	public void setShouldRain(boolean shold) {
		shouldRain = shold;
	}
}
